require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Running"

-- ==============================
-- Running: per-level multipliers
-- ==============================
-- Run speed multiplier (vs. baseline level 0 = 1.00)
-- Level 1..10 → 1.03, 1.06, 1.09, 1.12, 1.15, 1.18, 1.21, 1.24, 1.27, 1.30
local _RUN_SPEED_MULT_BY_LVL = { 1.03, 1.06, 1.09, 1.12, 1.15, 1.18, 1.21, 1.24, 1.27, 1.30 }

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    local runMult = _RUN_SPEED_MULT_BY_LVL[lvl] or 1.0
    local runPlusPct = math.floor(((runMult - 1.0) * 100) + 0.5)

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
    ctx.add(ST.getText("IGUI_DST_Running_val_RunSpeed", tostring(runPlusPct or "-")))
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)